DROP INDEX ADRFILE.MNTPNT_PK;

CREATE UNIQUE INDEX ADRFILE.MNTPNT_PK ON ADRFILE.MOUNT_POINT
(MOUNT_POINT_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.MNTPNT_APP_FK;

CREATE INDEX ADRFILE.MNTPNT_APP_FK ON ADRFILE.MOUNT_POINT
(APPLICATION_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.FLE_PK;

CREATE UNIQUE INDEX ADRFILE.FLE_PK ON ADRFILE.FILES
(FILE_ID)
LOGGING
TABLESPACE M_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.FLE_DIR_FK;

CREATE INDEX ADRFILE.FLE_DIR_FK ON ADRFILE.FILES
(DIRECTORY_ID)
LOGGING
TABLESPACE M_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DOCACCLOG_PK;

CREATE UNIQUE INDEX ADRFILE.DOCACCLOG_PK ON ADRFILE.DOCUMENT_ACCESS_LOG
(DOCUMENT_ACCESS_LOG_ID)
LOGGING
TABLESPACE M_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DOCACCLOG_FLE_FK;

CREATE INDEX ADRFILE.DOCACCLOG_FLE_FK ON ADRFILE.DOCUMENT_ACCESS_LOG
(FILE_ID)
LOGGING
TABLESPACE M_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DIR_PK;

CREATE UNIQUE INDEX ADRFILE.DIR_PK ON ADRFILE.DIRECTORY
(DIRECTORY_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DIR_MNTPNT_FK;

CREATE INDEX ADRFILE.DIR_MNTPNT_FK ON ADRFILE.DIRECTORY
(MOUNT_POINT_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DIR_APP_FK;

CREATE INDEX ADRFILE.DIR_APP_FK ON ADRFILE.DIRECTORY
(APPLICATION_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DIRPTN_PK;

CREATE INDEX ADRFILE.DIRPTN_PK ON ADRFILE.DIRECTORY_PATTERN
(DIRECTORY_PATTERN_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.DIRPTN_APP_FK;

CREATE INDEX ADRFILE.DIRPTN_APP_FK ON ADRFILE.DIRECTORY_PATTERN
(APPLICATION_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX ADRFILE.APP_PK;

CREATE UNIQUE INDEX ADRFILE.APP_PK ON ADRFILE.APPLICATION
(APPLICATION_ID)
LOGGING
TABLESPACE S_ADRFILE_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
